<?php

use yii\db\Migration;

/**
 * Class m180506_192428_add_table_registrations
 */
class m180506_192428_add_table_registrations extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->execute("CREATE TABLE `registration`( `id` INT(11) NOT NULL AUTO_INCREMENT, `user_id` INT(11) NOT NULL, `type_of_registration` VARCHAR(512) NOT NULL, `handler_first_name` VARCHAR(512) NOT NULL, `handler_last_name` VARCHAR(512) NOT NULL, `handler_street` VARCHAR(512) NOT NULL, `handler_city` VARCHAR(512) NOT NULL, `handler_state` VARCHAR(512) NOT NULL, `handler_zip` VARCHAR(512) NOT NULL, `handler_phone` VARCHAR(512) NULL, `dog_name` VARCHAR(512) NOT NULL, `dog_breed` VARCHAR(512) NOT NULL, `created_at` INT(11) NOT NULL, `updated_at` INT(11) NOT NULL, PRIMARY KEY (`id`), CONSTRAINT `fk_registration_user_user_id` FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ); ");

        $this->execute("ALTER TABLE `registration` ADD COLUMN `registration_no` VARCHAR(512) NOT NULL AFTER `user_id`; ");
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        echo "m180506_192428_add_table_registrations cannot be reverted.\n";

        return false;
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m180506_192428_add_table_registrations cannot be reverted.\n";

        return false;
    }
    */
}
