<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Registrations;

/**
 * registrationsSearch represents the model behind the search form of `common\models\registrations`.
 */
class RegistrationsSearch extends Registrations
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'created_at', 'updated_at'], 'integer'],
            [['registration_no', 'type_of_registration', 'handler_first_name', 'handler_last_name', 'handler_street', 'handler_city', 'handler_state', 'handler_zip', 'handler_phone', 'dog_name', 'dog_breed'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = registrations::find()->where(['user_id' => Yii::$app->user->id]);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'registration_no', $this->registration_no])
            ->andFilterWhere(['like', 'type_of_registration', $this->type_of_registration])
            ->andFilterWhere(['like', 'handler_first_name', $this->handler_first_name])
            ->andFilterWhere(['like', 'handler_last_name', $this->handler_last_name])
            ->andFilterWhere(['like', 'handler_street', $this->handler_street])
            ->andFilterWhere(['like', 'handler_city', $this->handler_city])
            ->andFilterWhere(['like', 'handler_state', $this->handler_state])
            ->andFilterWhere(['like', 'handler_zip', $this->handler_zip])
            ->andFilterWhere(['like', 'handler_phone', $this->handler_phone])
            ->andFilterWhere(['like', 'dog_name', $this->dog_name])
            ->andFilterWhere(['like', 'dog_breed', $this->dog_breed]);

        return $dataProvider;
    }
}
