<?php
namespace common\components;

use Yii;

class CsvExport {

    public static function export($model){
        header('Content-Type: text/csv; charset=utf-8');  
        header('Content-Disposition: attachment; filename=data.csv');  
        $output = fopen("php://output", "w");  
        
        fputcsv($output, [
            'Registration #',
            'Type of registration',
            'Handler Email',
            'Handler first name',
            'Handler last name',
            'Handler street',
            'Handler city',
            'Handler state',
            'Handler zip',
            'Handler phone',
            'Dog name',
            'Dog breed',
            'User ip address',
            'Source',
            'Created on'
        ]);  
        
        foreach ($model as $row) 
        {
           fputcsv($output, [
                $row->registration_no,
                $row->type_of_registration,
                $row->user->email,
                $row->handler_first_name,
                $row->handler_last_name,
                $row->handler_street,
                $row->handler_city,
                $row->handler_state,
                $row->handler_zip,
                $row->handler_phone,
                $row->dog_name,
                $row->dog_breed,
                $row->user_ip,
                $row->source,
                date("Y-m-d H:i:s", $row->created_at),
            ]);  
        }  
        
        fclose($output);
        return;
    }
} 