<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Registrations;

/**
 * RegistrationsSearch represents the model behind the search form of `common\models\registrations`.
 */
class RegistrationsSearch extends Registrations
{
    public $username;
    public $created_on;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'created_at', 'updated_at'], 'integer'],
            [['registration_no', 'type_of_registration', 'handler_first_name', 'handler_last_name', 'handler_street', 'handler_city', 'handler_state', 'handler_zip', 'handler_phone', 'dog_name', 'dog_breed', 'user_ip', 'source', 'username', 'created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Registrations::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                    //'title' => SORT_ASC, 
                ]
            ],
        ]);

        $query->joinWith('user');

        // $dataProvider->setSort([
        //     'attributes' => [
        //         'registration_no',
        //         'type_of_registration',
        //         'handler_first_name',
        //         'handler_last_name',
        //         'handler_street',
        //         'handler_city',
        //         'handler_state',
        //         'handler_zip',
        //         'handler_phone',
        //         'dog_name', 
        //         'dog_breed',
        //         'user_ip',
        //         'source',
        //         'created_on' => [
        //             'asc' => ['created_at' => SORT_ASC],
        //             'desc' => ['created_at' => SORT_DESC],
        //         ],
        //         'username' => [
        //             'asc' => ['user.username' => SORT_ASC],
        //             'desc' => ['user.username' => SORT_DESC],
        //         ]
        //     ]
        // ]);

        $dataProvider->sort->attributes['created_on'] = [
            'asc' => ['created_at' => SORT_ASC],
            'desc' => ['created_at' => SORT_DESC],
        ];
        $dataProvider->sort->attributes['username'] = [
            'asc' => ['user.username' => SORT_ASC],
            'desc' => ['user.username' => SORT_DESC],
        ];

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'registration_no', $this->registration_no])
            ->andFilterWhere(['like', 'type_of_registration', $this->type_of_registration])
            ->andFilterWhere(['like', 'handler_first_name', $this->handler_first_name])
            ->andFilterWhere(['like', 'handler_last_name', $this->handler_last_name])
            ->andFilterWhere(['like', 'handler_street', $this->handler_street])
            ->andFilterWhere(['like', 'handler_city', $this->handler_city])
            ->andFilterWhere(['like', 'handler_state', $this->handler_state])
            ->andFilterWhere(['like', 'handler_zip', $this->handler_zip])
            ->andFilterWhere(['like', 'handler_phone', $this->handler_phone])
            ->andFilterWhere(['like', 'dog_name', $this->dog_name])
            ->andFilterWhere(['like', 'dog_breed', $this->dog_breed])
            ->andFilterWhere(['like', 'user_ip', $this->user_ip])
            ->andFilterWhere(['like', 'registration.created_at', $this->created_on])
            ->andFilterWhere(['like', 'user.username', $this->username])
            ->andFilterWhere(['like', 'source', $this->source]);

        return $dataProvider;
    }
}
