<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\Url;
/* @var $this yii\web\View */
/* @var $searchModel common\models\RegistrationsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Welcome, '.Yii::$app->user->identity->username);
$this->params['breadcrumbs'][] = $this->title;
?>
<br>

<div class="pull-right">
    <a class="btn btn-success" href="<?php echo \yii\helpers\Url::to(['registration/create']); ?>">
        <i class="fa fa-plus" aria-hidden="true"></i>  Add
    </a>
    <!-- <a class="btn btn-warning" href="<?php echo \yii\helpers\Url::to(['registration/index']); ?>">
        <i class="fa fa-eye" aria-hidden="true"></i>   Change Password
    </a> -->
    <a class="btn btn-danger" href="<?php echo \yii\helpers\Url::to(['site/logout']); ?>">
        <i class="fa fa-lock" aria-hidden="true"></i>  Logout
    </a>
</div>
<br>
<div class="Registrations-index">


    <?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            //'id',
            //'user_id',
            'registration_no',
            'type_of_registration',
            'handler_first_name',
            'handler_last_name',
            //'handler_street',
            //'handler_city',
            //'handler_state',
            //'handler_zip',
            //'handler_phone',
            'dog_name',
            'dog_breed',
            //'created_at',
            //'updated_at',

            [
                'class' => 'yii\grid\ActionColumn',
                //'headerOptions' =>['style' => 'width:70px;'],
                'contentOptions' =>['style' => 'width:30%;'],
                'template' => '{resend}{update}',

                'buttons' => [
                    'resend' => function ($url, $model) {
                        return Html::a('<button type="button" class="btn btn-info"><span class="glyphicon glyphicon-envelope"></span>&nbsp;Resend Email</button>&nbsp;', Url::to(['resend', 'id'=>$model->id]), 
                        [
                            'title' => 'Resend',
                            'aria-label' => 'Resend',
                            'data-pjax' => '0',
                            'data-toggle' => 'tooltip'
                        ]);
                    },
                    'update' => function ($url, $model) {
                        return Html::a('<button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-pencil"></span>&nbsp;Update</button>', Url::to(['update', 'id'=>$model->id]), 
                        [
                            'title' => 'Update',
                            'aria-label' => 'Update',
                            'data-pjax' => '0',
                            'data-toggle' => 'tooltip'
                        ]);
                    },
                ],
            ],
        ],
    ]); ?>
    <?php Pjax::end(); ?>
</div>
