<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use frontend\models\SignupForm;
use frontend\models\ContactForm;
use common\models\Registrations;
use common\models\User;
use common\models\OldRegs;
/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout', 'signup'],
                'rules' => [
                    [
                        'actions' => ['signup'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post', 'get'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return mixed
     */
    public function actionIndex()
    {
        return $this->render('index');
    }

    /**
     * Logs in a user.
     *
     * @return mixed
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->redirect(['/registration/index']);;
        } else {
            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Logs out the current user.
     *
     * @return mixed
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    /**
     * Displays contact page.
     *
     * @return mixed
     */
    // public function actionContact()
    // {
    //     $model = new ContactForm();
    //     if ($model->load(Yii::$app->request->post()) && $model->validate()) {
    //         if ($model->sendEmail(Yii::$app->params['adminEmail'])) {
    //             Yii::$app->session->setFlash('success', 'Thank you for contacting us. We will respond to you as soon as possible.');
    //         } else {
    //             Yii::$app->session->setFlash('error', 'There was an error sending your message.');
    //         }

    //         return $this->refresh();
    //     } else {
    //         return $this->render('contact', [
    //             'model' => $model,
    //         ]);
    //     }
    // }

    /**
     * Displays about page.
     *
     * @return mixed
     */
    // public function actionAbout()
    // {
    //     return $this->render('about');
    // }

    /**
     * Signs user up.
     *
     * @return mixed
     */
    // public function actionSignup()
    // {
    //     $model = new SignupForm();
    //     if ($model->load(Yii::$app->request->post())) {
    //         if ($user = $model->signup()) {
    //             if (Yii::$app->getUser()->login($user)) {
    //                 return $this->goHome();
    //             }
    //         }
    //     }

    //     return $this->render('signup', [
    //         'model' => $model,
    //     ]);
    // }

    /**
     * Requests password reset.
     *
     * @return mixed
     */
    public function actionRequestPasswordReset()
    {
        $model = new PasswordResetRequestForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                Yii::$app->session->setFlash('success', 'Check your email for further instructions.');

                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Sorry, we are unable to reset password for the provided email address.');
            }
        }

        return $this->render('requestPasswordResetToken', [
            'model' => $model,
        ]);
    }

    /**
     * Resets password.
     *
     * @param string $token
     * @return mixed
     * @throws BadRequestHttpException
     */
    public function actionResetPassword($token)
    {
        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->setFlash('success', 'New password saved.');

            return $this->goHome();
        }

        return $this->render('resetPassword', [
            'model' => $model,
        ]);
    }

    public function actionRuncsv (){
        $handle = fopen("images/final_dog_records.csv", "r");
        $count = 0;

        $row = (new \yii\db\Query())
                ->select(['stored'])
                ->from('settings')
                ->one();

        print_r($row);
        exit; 

        for ($i = 0; $row = fgetcsv($handle ); ++$i) {
            // Do something will $row array

            $num = $row[0];
            $type = $row[1];
            $first_name = $row[2];
            $last_name = $row[3];
            $street = $row[4];
            $city = $row[5];
            $state = $row[6];
            $zip = $row[7];
            $phone = $row[8];
            $dog_name = htmlspecialchars_decode($row[9]);
            $dog_breed = $row[10];
            $email = $row[11];
            $password = $row[12];
            $idnum = $row[13];
            $ipadd = $row[14];

            if(empty($idnum) && empty($num)){
                echo "end of file!"; exit;
            }

            $oldReg = Registrations::findOne(['registration_no' => $idnum]);
            if($oldReg)
                continue;

            if(empty($password)){
                $password = "password";
            }

            //check if user exists
            $oldUser = User::findOne(['username' => $email]);
            if(!$oldUser){
                $user = new User();
                $user->username = $email;
                $user->email = $email;
                $user->setPassword($password);
                $user->generateAuthKey();
                if(!$user->save())
                    throw new \yii\web\HttpException(500, 'Error creating user, please contact the administrator.');  
            }
            else{
                $user = $oldUser;
            }

            $model = new Registrations();
            //$model->scenario = Registrations::SCENARIO_CREATE;

            $model->user_id = $user->id;
            $model->registration_no = $idnum;
            $model->type_of_registration = $type;
            $model->handler_first_name = $first_name;
            $model->handler_last_name = $last_name;
            $model->handler_street = $street;
            $model->handler_city = $city;
            $model->handler_state = $state;
            $model->handler_zip = $zip;
            $model->handler_phone = $phone;
            $model->dog_name = (strlen($dog_name) > 22) ? substr($dog_name,0,22) : $dog_name;
            $model->dog_breed = $dog_breed;
            $model->user_ip = $ipadd;

            if($model->save(false)){
                $count++; 
            } else {
                print_r($model->getErrors());
                exit;
            }
            //echo $count."<br>";

            if($i == 5)
                 break;

        }
        fclose($handle);
    }

    public function actionImport(){
        $rows = OldRegs::find()->limit(500)->all();
        foreach ($rows as $row) {
            
            $oldReg = Registrations::findOne(['registration_no' => $row->regno]);
            if($oldReg){
                $row->delete();
                //echo "record exists!<br>";
                continue;
            }
            
            $password = htmlspecialchars_decode($row->password);
            if(empty($password)){
                $password = "password";
            }
            
            //check if user exists
            $oldUser = User::findOne(['username' => $row->email]);
            if(!$oldUser){
                $user = new User();
                $user->username = $row->email;
                $user->email = $row->email;
                $user->setPassword($password);
                $user->generateAuthKey();
                if(!$user->save())
                    throw new \yii\web\HttpException(500, 'Error creating user, please contact the administrator.');  
            }
            else{
                $user = $oldUser;
            }

            $model = new Registrations();
            //$model->scenario = Registrations::SCENARIO_CREATE;

            $model->user_id = $user->id;
            $model->registration_no = $row->regno;
            $model->type_of_registration = $row->type;
            $model->handler_first_name = $row->fname;
            $model->handler_last_name = $row->lname;
            $model->handler_street = $row->street;
            $model->handler_city = $row->city;
            $model->handler_state = $row->state;
            $model->handler_zip = $row->zip;
            $model->handler_phone = $row->phone;
            $model->dog_name = (strlen($row->dog_name) > 22) ? substr($row->dog_name,0,22) : $row->dog_name;
            $model->dog_breed = $row->dog_breed;
            $model->user_ip = $row->regip;

            if($model->save(false)){
                //echo $row->id."<br>";
                $row->delete();
            } else {
                print_r($model->getErrors());
                exit;
            }
        }
        echo OldRegs::find()->count();
    }
}
