<?php
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model backend\models\ExportForm */
/* @var $form ActiveForm */
$this->title = Yii::t('app', 'Export Registrations');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="registration-export col-md-4">

    <?php $form = ActiveForm::begin(); ?>

	  	<?php echo $form->field($model, 'type_of_registration')->dropDownList(
                [
                	'All' => 'All',
                	'Service Dog' => 'Service Dog', 
                	'Emotional Support Animal' => 'Emotional Support Animal'
                ], 
                ['prompt'=>'Select a Type']);
        ?>
		
		<?= '<label class="control-label">From Date</label>';?>
        <?= DatePicker::widget([
			'model' => $model,
    		'attribute' => 'dateFrom',
			//'value' => date('d-M-Y', strtotime('-2 days')),
			'options' => ['placeholder' => 'Select From date ...'],
			'pluginOptions' => [
				'format' => 'dd-M-yyyy',
				'todayHighlight' => true
			]
		]);?>
		
		<br>
		
		<?= '<label class="control-label">To Date</label>';?>
		<?= DatePicker::widget([
			'model' => $model,
    		'attribute' => 'dateTo',
			//'value' => date('d-M-Y', strtotime('Today')),
			'options' => ['placeholder' => 'Select to date ...'],
			'pluginOptions' => [
				'format' => 'dd-M-yyyy',
				'todayHighlight' => true
			]
		]);?>
        
    	<br><br>
        <div class="form-group">
            <?= Html::submitButton('Download Csv', ['class' => 'btn btn-primary']) ?>
        </div>
    <?php ActiveForm::end(); ?>

</div><!-- registration-export -->
